<?php 
namespace Opencart\Admin\Controller\Extension\OfflineCC\Payment;

class OfflineCC extends \Opencart\System\Engine\Controller { 

	private $error = array(); 

	public function index() {
		$this->load->language('extension/offline_cc/payment/offline_cc');
		
		$this->load->model('extension/offline_cc/payment/offline_cc');
		$this->model_extension_payment_offline_cc->check_cc_field();

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
			
		

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['text_authorization'] = $this->language->get('text_authorization');
		$data['text_capture'] = $this->language->get('text_capture');		
		
	
		$data['entry_total'] = $this->language->get('entry_total');	
		$data['entry_order_status'] = $this->language->get('entry_order_status');		
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_encryption'] = $this->language->get('entry_encryption');
		
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['tab_general'] = $this->language->get('tab_general');

 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'user_token=' . $this->session->data['user_token'], 'SSL'),
      		'separator' => false
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_payment'),
			'href'      => $this->url->link('marketplace/extension&type=payment', 'user_token=' . $this->session->data['user_token'], 'SSL'),
      		'separator' => ' :: '
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('extension/payment/offline_cc', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
				
		$data['save'] = $this->url->link('extension/offline_cc/payment/offline_cc.save', 'user_token=' . $this->session->data['user_token']);
		
		$data['action'] = $this->url->link('extension/payment/offline_cc', 'user_token=' . $this->session->data['user_token'], 'SSL');
		
		$data['cancel'] = $this->url->link('marketplace/extension&type=payment&user_token=', 'user_token=' . $this->session->data['user_token'], 'SSL');
		
		if (isset($this->request->post['payment_offline_cc_total'])) {
			$data['payment_offline_cc_total'] = $this->request->post['payment_offline_cc_total'];
		} else {
			$data['payment_offline_cc_total'] = $this->config->get('payment_offline_cc_total'); 
		} 
				
		if (isset($this->request->post['payment_offline_cc_order_status_id'])) {
			$data['payment_offline_cc_order_status_id'] = $this->request->post['payment_offline_cc_order_status_id'];
		} else {
			$data['payment_offline_cc_order_status_id'] = $this->config->get('payment_offline_cc_order_status_id'); 
		} 

		$this->load->model('localisation/order_status');
		
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['payment_offline_cc_geo_zone_id'])) {
			$data['payment_offline_cc_geo_zone_id'] = $this->request->post['payment_offline_cc_geo_zone_id'];
		} else {
			$data['payment_offline_cc_geo_zone_id'] = $this->config->get('payment_offline_cc_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['payment_offline_cc_status'])) {
			$data['payment_offline_cc_status'] = $this->request->post['payment_offline_cc_status'];
		} else {
			$data['payment_offline_cc_status'] = $this->config->get('payment_offline_cc_status');
		}
		
		if (isset($this->request->post['payment_offline_cc_sort_order'])) {
			$data['payment_offline_cc_sort_order'] = $this->request->post['payment_offline_cc_sort_order'];
		} else {
			$data['payment_offline_cc_sort_order'] = $this->config->get('payment_offline_cc_sort_order');
		}
		
		if (isset($this->request->post['payment_offline_cc_email'])) {
			$data['payment_offline_cc_email'] = $this->request->post['payment_offline_cc_email'];
		} else {
			$data['payment_offline_cc_email'] = $this->config->get('payment_offline_cc_email'); 
		}
		
		if (isset($this->request->post['payment_offline_cc_encryption'])) {
			$data['payment_offline_cc_encryption'] = $this->request->post['payment_offline_cc_encryption'];
		} else {
			$data['payment_offline_cc_encryption'] = $this->config->get('payment_offline_cc_encryption'); 
		}
		
		
		if (isset($this->request->post['payment_offline_cc_entry_use_cc_name'])) {
			$data['payment_offline_cc_entry_use_cc_name'] = $this->request->post['payment_offline_cc_entry_use_cc_name'];
		} else {
			$data['payment_offline_cc_entry_use_cc_name'] = $this->config->get('payment_offline_cc_entry_use_cc_name'); 
		}
		
		if (isset($this->request->post['entry_use_cc_type'])) {
			$data['payment_offline_cc_entry_use_cc_type'] = $this->request->post['payment_offline_cc_entry_use_cc_type'];
		} else {
			$data['payment_offline_cc_entry_use_cc_type'] = $this->config->get('payment_offline_cc_entry_use_cc_type'); 
		}
		
		if (isset($this->request->post['payment_offline_cc_entry_accept_visa'])) {
			$data['payment_offline_cc_entry_accept_visa'] = $this->request->post['payment_offline_cc_entry_accept_visa'];
		} else {
			$data['payment_offline_cc_entry_accept_visa'] = $this->config->get('payment_offline_cc_entry_accept_visa'); 
		}
		
		if (isset($this->request->post['payment_offline_cc_entry_accept_master'])) {
			$data['payment_offline_cc_entry_accept_master'] = $this->request->post['payment_offline_cc_entry_accept_master'];
		} else {
			$data['payment_offline_cc_entry_accept_master'] = $this->config->get('payment_offline_cc_entry_accept_master'); 
		}
		
		if (isset($this->request->post['payment_offline_cc_entry_accept_ae'])) {
			$data['payment_offline_cc_entry_accept_ae'] = $this->request->post['payment_offline_cc_entry_accept_ae'];
		} else {
			$data['payment_offline_cc_entry_accept_ae'] = $this->config->get('payment_offline_cc_entry_accept_ae'); 
		}
		
		if (isset($this->request->post['payment_offline_cc_entry_accept_cu'])) {
			$data['payment_offline_cc_entry_accept_cu'] = $this->request->post['payment_offline_cc_entry_accept_cu'];
		} else {
			$data['payment_offline_cc_entry_accept_cu'] = $this->config->get('payment_offline_cc_entry_accept_cu'); 
		}
		
		if (isset($this->request->post['payment_offline_cc_entry_accept_jcb'])) {
			$data['payment_offline_cc_entry_accept_jcb'] = $this->request->post['payment_offline_cc_entry_accept_jcb'];
		} else {
			$data['payment_offline_cc_entry_accept_jcb'] = $this->config->get('payment_offline_cc_entry_accept_jcb'); 
		}
		 

		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/offline_cc/payment/offline_cc', $data));
	}
	
	public function save(){
		$json = ['status' => false,'error' => 'Oops! Something went wrong']; 
		if ( $this->validate()) {
			$this->language->load('extension/offline_cc/payment/offline_cc');
			$this->model_setting_setting->editSetting('payment_offline_cc', $this->request->post);	 
			$json = ['status' => true, 'success' =>  $this->language->get('text_success')];
			//$this->response->redirect($this->url->link('marketplace/extension&type=payment', 'user_token=' . $this->session->data['user_token'], 'SSL'));
		}
		echo json_encode($json);
		exit; 
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'extension/offline_cc/payment/offline_cc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>