<?php
//==============================================================================
// Manufacturer-Based Shipping v156.1
//
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
//==============================================================================

namespace Opencart\Admin\Controller\Extension\ManufacturerBasedShipping\Shipping;

class ManufacturerBasedShipping extends \Opencart\System\Engine\Controller {   
	private $error = array();
 	private $type = 'shipping';
	private $name = 'shipping_manufacturerbased';
	
	public function index() {
		$data['type'] = $this->type;
		$data['name'] = $this->name;
		
		$token = $data['user_token'] = (isset($this->session->data['user_token'])) ? $this->session->data['user_token'] : '';
		$version = $data['version'] = (!defined('VERSION')) ? 140 : (int)substr(str_replace('.', '', VERSION), 0, 3); 	
		$data = array_merge($data, $this->load->language('extension/manufacturer_based_shipping/'.$this->type . '/manufacturer_based_shipping')); 
		$data['exit'] = $this->makeURL('marketplace/extension&type=' . $this->type, 'user_token=' . $token, 'SSL');
		$this->load->model('setting/setting');
		
		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			if (isset($this->request->post) && strlen(serialize($this->request->post)) > 65535) {
				$setting_table = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "setting WHERE Field = 'value'");
				if (strtolower($setting_table->row['Type']) == 'text') {
					$this->db->query("ALTER TABLE " . DB_PREFIX . "setting MODIFY `value` MEDIUMTEXT NOT NULL");
				}
			}
			$postdata = $this->request->post;
			if ($version < 151) {
				foreach ($postdata as $key => $value) {
					if (is_array($value)) $postdata[$key] = serialize($value);
				}
			}
			$this->model_setting_setting->editSetting($this->name, $postdata);
			file_put_contents(DIR_LOGS.'clearthinking.txt',date('Y-m-d H:i:s')."\t".$this->request->server['REMOTE_ADDR']."\t".serialize($this->request->post)."\n",FILE_APPEND|LOCK_EX);
			$this->session->data['success'] = $data['standard_success'];
			$this->redirect(isset($this->request->get['exit']) ? $data['exit'] : $this->makeURL($this->type . '/' . $this->name, 'user_token=' . $token, 'SSL'));
		}
		
		$breadcrumbs = array();
		$breadcrumbs[] = array(
			'href'		=> $this->makeURL('common/dashboard', 'user_token=' . $token, 'SSL'),
			'text'		=> $data['text_home'],
			'separator' => false
		);
		$breadcrumbs[] = array(
			'href'		=> $this->makeURL('marketplace/extension&type=' . $this->type, 'user_token=' . $token, 'SSL'),
			'text'		=> $data['standard_' . $this->type],
			'separator' => ' :: '
		);
		$breadcrumbs[] = array(
			'href'		=> $this->makeURL($this->type . '/' . $this->name, 'user_token=' . $token, 'SSL'),
			'text'		=> $data['heading_title'],
			'separator' => ' :: '
		);
		$data['breadcrumbs'] = $breadcrumbs;
		$data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
		$data['success'] = (isset($this->session->data['success'])) ? $this->session->data['success'] : '';
		unset($this->session->data['success']);
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE `code` = '" . $this->db->escape($this->name) . "' ORDER BY `key` ASC");
		foreach ($query->rows as $setting) {
			$value = isset($this->request->post[$setting['key']]) ? $this->request->post[$setting['key']] : $setting['value'];
			$data[$setting['key']] = (is_string($value) && strpos($value, 'a:') === 0) ? unserialize($value) : $value;
		}
		
		// non-standard
		$data['selectall_links'] = '<div class="selectall-links"><a onclick="$(this).parent().prev().find(\':checkbox\').attr(\'checked\', true)">' . $data['text_select_all'] . '</a> / <a onclick="$(this).parent().prev().find(\':checkbox\').attr(\'checked\', false)">' . $data['text_unselect_all'] . '</a></div>';
		
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		
		$this->load->model('localisation/tax_class');
		$data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();
		array_unshift($data['tax_classes'], array('tax_class_id' => 0, 'title' => $data['text_none']));
		
		$data['order_criteria'] = array(
			'store',
			'currency',
			'customer_group',
			'geo_zone'
		);
		
		$stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "store ORDER BY name");
		$data['stores'] = $stores->rows;
		array_unshift($data['stores'], array('store_id' => 0, 'name' => $this->config->get('config_name')));
		
		$currencies = $this->db->query("(SELECT * FROM " . DB_PREFIX . "currency WHERE status = '1' AND `code` = '" . $this->config->get('config_currency') . "') UNION (SELECT * FROM " . DB_PREFIX . "currency WHERE status = '1' AND `code` != '" . $this->config->get('config_currency') . "')");
		$data['currencys'] = array(array('currency_id' => 'autoconvert', 'name' => $data['text_convert_unselected']));
		foreach ($currencies->rows as $currency) {
			$data['currencys'][] = array('currency_id' => $currency['code'], 'name' => $currency['title']);
		}
		
		$this->load->model('sale/customer_group');
		$data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
		array_unshift($data['customer_groups'], array('customer_group_id' => 0, 'name' => $data['text_not_logged_in']));
		
		$this->load->model('localisation/geo_zone');
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		array_unshift($data['geo_zones'], array('geo_zone_id' => 0, 'name' => $data['text_all_other_zones']));
		
		$data['cart_criteria'] = array(
			'length',
			'width',
			'height',
			'item',
			'total',
			'volume',
			'weight'
		);
		
		$data['rate_types'] = array(
			'item',
			'postcode',
			'total',
			'volume',
			'weight'
		);
		
		$data['item_unit'] = '#';
		$data['postcode_unit'] = '#';
		$data['total_unit'] = '&curren;';
		if ($version < 151) {
			$data['length_unit'] = $data['width_unit'] = $data['height_unit'] = $this->config->get('config_length_class');
			$data['volume_unit'] = $this->config->get('config_length_class') . '&sup3;';
			$data['weight_unit'] = $this->config->get('config_weight_class');
		} else {
			$length = $this->db->query("SELECT * FROM " . DB_PREFIX . "length_class_description WHERE length_class_id = " . (int)$this->config->get('config_length_class_id'));
			$data['length_unit'] = $data['width_unit'] = $data['height_unit'] = $length->row['unit'];
			$data['volume_unit'] = $length->row['unit'] . '&sup3;';
			$weight = $this->db->query("SELECT * FROM " . DB_PREFIX . "weight_class_description WHERE weight_class_id = " . (int)$this->config->get('config_weight_class_id'));
			$data['weight_unit'] = $weight->row['unit'];
		}
		
		$data['comparisons'] = array(
			'any',
			'all',
			'not',
			'onlyany',
			'onlyall',
			'none'
		);
		
		// Extension-specific
		$this->load->model('catalog/manufacturer');
		$manufacturers = $this->model_catalog_manufacturer->getManufacturers();
		$data['manufacturer_checkboxes'] = '';
		foreach ($manufacturers as $m) {
			$data['manufacturer_checkboxes'] .= '<label><div><input type="checkbox" name="' . $this->name . '_data[#ROW#][manufacturers][]" value="' . $m['manufacturer_id'] . '" /> ' . $m['name'] . '</div></label>';
		}
		// end
		// echo '<pre>';
		// print_r($data);
		// exit;
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('extension/manufacturer_based_shipping/shipping/manufacturer_based_shipping', $data)); 
	}
	
	private function makeURL($route, $args = '', $connection = 'NONSSL') {
		if (!defined('VERSION') || VERSION < 1.5) {
			$url = ($connection == 'NONSSL') ? HTTP_SERVER : HTTPS_SERVER;
			$url .= 'index.php?route=' . $route;
			$url .= ($args) ? '&' . ltrim($args, '&') : '';
			return $url;
		} else {
			return $this->url->link($route, $args, $connection);
		}
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'extension/'.$this->type . '/' . $this->name)) {
			$this->error['warning'] = $data['standard_error'];
		}
		return ($this->error) ? false : true;
	}
	 
} 